; JAWS scripts for Band-In-A-Box 2025 
; Peter Torpey - January, 2025

; 1/15 - re-added the JAWSKey+F1 hotkey that was overwritten by new JAWS
; 8-24 - changed UpdateBarBeatPart due to changes in JAWS 2024
; Changed back to using schedule function to update the bar/beat/part due to changes in JAWS
; was using the NewTextEvent function to trigger call to UpdateBarBeatPart instead of using ScheduleFunction
;
; thanks to Rich Caloggero who contributed to additional scripts and functions for the Style Picker dialog

;use "test.jsb"
;use "HTML and Windows Help.jsb"
 include "hjconst.jsh"
include "hjglobal.jsh"
include"common.jsm"
include "bbw.jsh"
include "bbw.jsm"

void function AutoStartEvent()
var
	handle hwnd

Initializations()

let giNewPart = true

; start checking for a change in the bar, beat, or part on a regular basis
let iTime = 1
; uncommented out the next line since we are no longer triggering speaking of bar/beat/part with NewTextEvent function
let iUSUpdateBarBeatPart = ScheduleFunction ("UpdateBarBeatPart", iTime )

; warn the user if the Notation window and not the Chord window is visible
let hwnd = FindWindow (GetAppMainWindow(GetFocus()), cTStaffWindow, "" )
if IsWindowVisible (hwnd) then
	; the notation window is visible
	SayMessage (OT_MESSAGE, msgNotationWindow )
EndIf

if iFirstTime == 0 then
	; this code is run only the first time the script is started
	iFirstTime = 1
	iBIABVersion = GetProgramVersion (GetAppFilePath())
	giSpeakWhilePlaying = ReadSettingInteger ("Speech", sSpeakWhilePlaying, 0, FT_JSI, rsStandardLayering , "bbw")
	giSpeakHints = ReadSettingInteger ("Speech", sSpeakHints, 0, FT_JSI, rsStandardLayering , "bbw")
EndIf

EndFunction


void function initializations()
	var string sVersionInfo

sVersionInfo = GetVersionInfoString (GetAppFilePath(), "FileVersion") 
iVersion = StringToInt( StringSegment (sVersionInfo, ".", 1) )
; initialization of required parameters

; for the instruments list in the main dialog window
let saInstruments = new StringArray[9]
	let saInstruments[1] = "Master"
	let saInstruments[2] = "Bass"
	let saInstruments[3] = "Piano"
	let saInstruments[4] = "Drums"
	let saInstruments[5] = "Guitar"
	let saInstruments[6] = "Soloist"
	let saInstruments[7] = "Strings"
	let saInstruments[8] = "Melody"
	let saInstruments[9] = "Thru"

; for the headings in the Preferences / Channels / MIDI Settings dialog
let saMSHeadings = new StringArray[9]
let saMSHeadings[1] = "Channel"
let saMSHeadings[2] = "Octave"
let saMSHeadings[3] = "Patch"
let saMSHeadings[4] = "Volume"
let saMSHeadings[5] = "Reverb"
let saMSHeadings[6] = "Chorus"
let saMSHeadings[7] = "Pan"
let saMSHeadings[8] = "Bank0"
let saMSHeadings[9] = "LSB(32)"

Endfunction





Script ScriptFileName ()
var
  string text


let text = FormatString (msgScriptInfo, GetAppFileName(), ScriptVersion, ReleaseDate )

if IsSameScript () then
	SayMessage (OT_USER_BUFFER, text )
else
	SayMessage (OT_MESSAGE, text )
EndIf

EndScript

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	string sClass,
	string sName

; the following two lines were added to make pop-up hints speak properly when using standard navigation commands
;RouteJAWSToPc ()
let gsLastHint = ""

let sClass = GetWindowClass (FocusWindow) 
let sName = GetWindowName( GetParent (FocusWindow ))

;SayString( "x" + sClass + "x x" + sName + "x" )

if giControlW == 1 then
	; eliminates extraneous speech when switching between the Chord and Notation windows
	let giControlW = 0
;	PCCursor ()
	return
	EndIf
	
if StringStartsWith(GetWindowName(GetRealWindow(GetCurrentWindow())),sStylePicker) then 
	giCurrentView = iStylePicker
	
ElIf StringCompare( sName, sMIDISettings, TRUE  ) == 0 then
	giCurrentView = iMIDISettingsDialogView
	If StringCompare (sName, GetWindowName( GetParent (PrevWindow)), FALSE) then
		; if we have switched into the MIDI Settings Dialog then speak this message,
		; otherwise we are already in the MIDI Settings dialog and don't need to speak this message
		SayMessage (OT_MESSAGE, msgUseControlTab )
	EndIf
	MIDISettingsDialog()
Elif sClass == cTLmDEdit then
	let giCurrentView = iEditView
else
	giCurrentView = 0
EndIf

FocusChangedEvent (FocusWindow, PrevWindow)

;PCCursor ()

Endfunction


Void Function WindowCreatedEvent (handle hWindow, int nLeft, int nTop, int nRight, int nBottom)
var
	string sClass,
	string sName

let sClass = GetWindowClass (hWindow)
let sName = GetWindowName (hWindow)
;SayString( "Window created: " + sClass + " " + sName + "x" )

If sClass == cMMDEVAPI ||
	sClass == cTPAUSEMESSAGEDIALOG then
	; to read the text contained in pop up dialogs
	Pause()
	SayWindow ( GetParent (GetFocus()), READ_EVERYTHING )
	EndIf

if sClass == cTLyricEdit then
	ghwnd = hWindow
	ScheduleFunction ("GoToLyricWindow", 5)
EndIf

WindowCreatedEvent (hWindow, nLeft, nTop, nRight, nBottom)
EndFunction


Void Function NewTextEvent(handle hwnd, string buffer, int nAttributes,
	int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
var
	string sClass

let sClass = GetWindowClass (hwnd)
;SayString("New text from class: " + sClass + " " + buffer)
if giIsPlaying == 1 && gsBar != "" then return EndIf

if sClass  == cChordWindow then
	; text captured here is processed by the UpdateBarBeatPart function
	; commented out the following line since we ar now using ScheduleFunction to update the bar/beat/part
;		UpdateBarBeatPart()
				return
EndIf

NewTextEvent(hwnd, buffer, nAttributes,nTextColor, nBackgroundColor, nEcho, sFrameName)

EndFunction



Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)   
var
	int num,
	string suf

;SayMessage(OT_USER_BUFFER, strKeyName )
;SayString( strKeyName )
;SayInteger( nKey )

KeyPressedEvent (nKey, strKeyName, nIsBrailleKey, nIsScriptKey)

if giCurrentView == iMIDISettingsDialogView then
	MIDISettingsDialogKeys( strKeyName )
	return
EndIf

; when the spacebar is pressed
if StringCompare( strKeyName, "space", false ) == 0 then gsChords = "" EndIf

; for control+shift commands
IF StringContains( strKeyName, "Control+" ) &&
  StringContains( strKeyName, "Shift+" ) then
	SayControlShiftCommands( strKeyName )
	Return
EndIf ; end of control+shift commands

; for control+Alt commands
IF StringContains( strKeyName, "Control+" ) &&
  StringContains( strKeyName, "Alt+" ) then
	SayControlAltCommands( strKeyName )
	Return
EndIf ; end of control+alt commands

; do not take any other action for the following keystrokes which have already been passed through to the application
if StringContains (strKeyName, "Shift+") &&
	StringContains (strKeyName, "Alt+" ) then
	return
EndIf

; for instrument mute/unmute and selection
if StringContains(strKeyName, "Alt+" ) then
	SayMutedStatus( strKeyName )
	Return
Elif StringContains(strKeyName, "Control+" ) then
	SaySelectedStatus( strKeyName )
	Return
EndIf ; end of instrument mute/unmute and selection

EndFunction


Script ControlRightArrow ()

if IsPCCursor() && !InTextWindow () then
  {Control+rightArrow}
  Return
EndIf
PerformScript SayNextWord()

EndScript

Script ControlLeftArrow ()

if IsPCCursor() && !InTextWindow () then
  {Control+Left Arrow}
  Return
EndIf
PerformScript SayPriorWord()

EndScript

void function SayMutedStatus( string strKeyName )
var
	int num,
	string suf,
	handle hwnd0,
	string text,
	int color,
	int ret,
	int i

; grab last part of key name
let suf = StringSegment (strKeyName, "+", -1)
if StringLength( suf ) != 1 ||
	!StringContainsChars (suf, "234567890") then 
	return
EndIf

text = MoveToInstrumentsWindow( strKeyName )
SayMessage (OT_MESSAGE, text )

SaveCursor ()
JAWSCursor ()
; if this is the Master, we have to check the color of some other instrument because this doesn't change color
num = StringToInt (suf)
if num == 2 then
		hwnd0 = GetAppMainWindow (GetCurrentWindow())
			hwnd0 = FindWindow (hwnd0, "TTrackRadios", "")
		MoveToWindow (hwnd0)
		NextWord ()
	EndIf

if GetColorText () == 255 then
	SayMessage (OT_MESSAGE, msgMuted )
else
	SayMessage (OT_MESSAGE, msgUnmuted )
EndIf

	; if this was the Master, move back to it
if num == 2 then
		PriorWord ()
	EndIf

RestoreCursor ()

EndFunction

String Function MoveToInstrumentsWindow (string strKeyName)
var
	handle hwnd0,
	string text,
	string suf,
	int num,
	int i

; grab last part of key name
let suf = StringSegment (strKeyName, "+", -1)

SaveCursor ()
JAWSCursor ()
Refresh (1)
Pause ()

if StringContainsChars (suf, "234567890") then
	let num = StringToInt (suf)
	if num==0 then let num = 10 EndIf
else
	return( "instrument not found" )
EndIf

; find the window that contains the various instruments
hwnd0 = GetAppMainWindow (GetCurrentWindow())

hwnd0 = FindWindow (hwnd0, "TTrackRadios", "")
MoveToWindow (hwnd0)
Pause()
JAWSHome ()
	i = num
	if i==0 then i=10 EndIf
	i = i - 2
	while i>0 
		NextChunk ()
				i = i - 1
	EndWhile
	text = GetChunk ()

RestoreCursor ()

return( text )

EndFunction



void function SaySelectedStatus( string strKeyName )
var
	int num,
	string suf,
	handle hwnd,
	string text,
	int ret

; grab last part of key name
let suf = StringSegment (strKeyName, "+", -1)
if StringLength( suf ) != 1 ||
	!StringContainsChars (suf, "234567890") then 
	return
EndIf

text = MoveToInstrumentsWindow( strKeyName )
SayMessage (OT_MESSAGE, text )

SaveCursor ()
JAWSCursor ()

	SayMessage( OT_MESSAGE, msgSelected )
	SayMessage (OT_MESSAGE, msgRightClick )
	SayMessage (OT_MESSAGE, msgActivatePCCursor )

EndFunction


void function SayControlShiftCommands( string strKeyName )
var
	int num,
	string suf

; grab last part of key name
let suf = StringSegment (strKeyName, "+", -1)

If suf == "-" then
	SayMessage( OT_MESSAGE, msgDecreasePatchNumber )
	Return
ElIf suf == "Equals" then
	SayMessage( OT_MESSAGE, msgIncreasePatchNumber )
	Return
EndIf

if StringLength( suf ) != 1 then
	; only single character endings are allowed past this point
	Return
EndIf

let num = StringToInt( suf )
If suf == "q" then
	SayMessage( OT_MESSAGE, msgDecreaseVolume )
ElIf suf == "w" then
	SayMessage( OT_MESSAGE, msgIncreaseVolume )
ElIf suf == "e" then
	SayMessage( OT_MESSAGE, msgDecreasePan )
ElIf suf == "r" then
	SayMessage( OT_MESSAGE, msgIncreasePan )
ElIf suf == "t" then
	SayMessage( OT_MESSAGE, msgDecreaseMidiReverb )
ElIf suf == "y" then
	SayMessage( OT_MESSAGE, msgIncreaseMidiReverb )
ElIf suf == "u" then
	SayMessage( OT_MESSAGE, msgDecreaseAudioReverb )
ElIf suf == "i" then
	SayMessage( OT_MESSAGE, msgIncreaseAudioReverb )
ElIf suf == "o" then
	SayMessage( OT_MESSAGE, msgDecreaseBank0 )
ElIf suf == "p" then
	SayMessage( OT_MESSAGE, msgIncreaseBank0 )
ElIf num>=0 && num<=9
	&& StringContains (suf, "0123456789") then
	SayMessage( OT_MESSAGE, msgSelectingPatch + IntToString(num) )
EndIf

EndFunction



void function SayControlAltShiftCommands( string strKeyName )
var
	string suf

; grab last part of key name
let suf = StringSegment (strKeyName, "+", -1)

if StringLength( suf ) != 1 then
	; only single character endings are allowed past this point
	Return
EndIf

If suf == "q" then
	SayMessage( OT_MESSAGE, msgReduceAllPartVolumes )
ElIf suf == "s" then
	SayMessage( OT_MESSAGE, msgIncreaseAllPartVolumes )
ElIf suf == "e" then
	SayMessage( OT_MESSAGE, msgSetAllPartVolumes )
ElIf suf == "r" then
	SayMessage( OT_MESSAGE, msgSetCurrentPartsVolume )
;xx
ElIf suf == "1" then
	SayMessage( OT_MESSAGE, msgTransposeMelodyDown1 )
ElIf suf == "2" then
	SayMessage( OT_MESSAGE, msgTransposeMelodyUp1 )
ElIf suf == "3" then
	SayMessage( OT_MESSAGE, msgTransposeSoloistDown1 )
ElIf suf == "4" then
	SayMessage( OT_MESSAGE, msgTransposeSoloistUp1 )
ElIf suf == "5" then
	SayMessage( OT_MESSAGE, msgTransposeDown1 )
ElIf suf == "6" then
	SayMessage( OT_MESSAGE, msgTransposeUp1 )
ElIf suf == "7" then
	SayMessage( OT_MESSAGE, msgTransposeSettingDialog )
EndIf

EndFunction

void function SayControlAltCommands( string strKeyName )
var
	string suf

; grab last part of key name
let suf = StringSegment (strKeyName, "+", -1)

if StringLength( suf ) != 1 then
	; only single character endings are allowed past this point
	Return
EndIf

If suf == "a" then
	SayMessage( OT_MESSAGE, msgDecreaseMasterVolume )
ElIf suf == "s" then
	SayMessage( OT_MESSAGE, msgIncreaseMasterVolume )
ElIf suf == "d" then
	SayMessage( OT_MESSAGE, msgSetMasterVolume )
ElIf suf == "1" then
	SayMessage( OT_MESSAGE, msgTransposeMelodyDown1 )
ElIf suf == "2" then
	SayMessage( OT_MESSAGE, msgTransposeMelodyUp1 )
ElIf suf == "3" then
	SayMessage( OT_MESSAGE, msgTransposeSoloistDown1 )
ElIf suf == "4" then
	SayMessage( OT_MESSAGE, msgTransposeSoloistUp1 )
ElIf suf == "5" then
	SayMessage( OT_MESSAGE, msgTransposeDown1 )
ElIf suf == "6" then
	SayMessage( OT_MESSAGE, msgTransposeUp1 )
ElIf suf == "7" then
	SayMessage( OT_MESSAGE, msgTransposeSettingDialog )
EndIf

EndFunction



Void Function UpdateBarBeatPart ()
var
	handle hwnd,
	string text,
	int num

let hwnd = FindWindow (0, cTBandWindow )

;let text = GetWindowName (hwnd)

; when there was a bug in JAWS 16, the preceding line had to be replaced with the line below - now this is fixed as of 7-14
; 8-24 put the below line back in and commented out the previous line for changes in JAWS 2024
let text = GetWindowTextEx (hwnd, FALSE, FALSE, FALSE)
;SayString( text)

; find where the bar and beat info starts
let text = StringReverse (text)
let num = StringContains (text, "raB") + 2
let text = StringLeft (text, num)
let text = StringReverse (text)
let gsBar = StringSegment (text, ", ", 2)

; test to see if this bar contains the part
let gsPart = StringRight (gsBar, 1)
if StringContainsChars ( gsPart, "abcdefghijklmnopqrstuvwx") > 0 then
	; since this bar contains the part extract it
	let gsBar = stringChopRight (gsBar, 1)
else
	; there is no part marker
	let gsPart = "-"
EndIf

if StringSegment (text, ", ", 4 ) == "Beat" then
	let gsBeat = StringSegment (text, ", ", 5 )
	let giIsPlaying = 0
Else
	let gsBeat = ""
	let giIsPlaying = 1
EndIf
; now we have gotten the bar, beat, and part info

; check to see if the bar or beat has changed
if gsBar!=gsPrevBar || gsBeat!=gsPrevBeat || gsPart != gsPrevPart then
	; if the bar or beat has changed we need to look for the new chords
			UpdateChords()
	let gsPrevBar = gsBar
	let gsPrevBeat = gsBeat
	if gsPart!=gsPrevPart then
		; if the part has changed we set a flag to be used in the SayBarBeatPart() function
		let giNewPart = True 
		let gsPrevPart = gsPart
	EndIf
	SayBarBeatPart()
	SayChord( gsChords )
EndIf

if (!IsVirtualPCCursor () && IsPCCursor ()) && 
  (GetWindowClass (GetCurrentWindow()) == cTBandWindow || GetWindowName (GetCurrentWindow())=="Chord Sheet") then
	sCurrentBrailleStrip = gsBar + gsPart + ":" + gsBeat + "  " + gsChords
	BrailleString (sCurrentBrailleStrip)
;	BrailleMessage (sCurrentBrailleStrip, 0, 0)
;	BrailleMessageRepeatLast ()
EndIf

; schedule the next time to update the bar, beat, part info
; we are no longer using the NewTextEvent function to do this update
let iUSUpdateBarBeatPart = ScheduleFunction ("UpdateBarBeatPart", iTime )

EndFunction

Function SayBarBeatPart ()
var
	string text

if giIsPlaying && giSpeakWhilePlaying >=  2 then return EndIf

if !giIsPlaying Then
	; do not speak the word "bar" if the tune is playing
	SayMessage( OT_MESSAGE, msgBar )
EndIf
SayMessage (OT_MESSAGE, gsBar )

if gsBeat != "" then
SayMessage( OT_MESSAGE, msgBeat + " " + gsBeat )
EndIf

if giNewPart == true && !giIsPlaying then
	SayMessage( OT_MESSAGE, msgPartChanged+ " " + gsPart )
		giNewPart = false
ElIf giSayPart == true then
	SayMessage( OT_MESSAGE, msgPart+ " " + gsPart )
EndIf
return

EndFunction

Script Speaklocation ()

giSayPart = true
SayBarBeatPart()
giSayPart = false
EndScript

Void Function UpdateChords ()
var
	int ret,
	handle hwnd,
		int iBreak,
	string sTmp,
	string text,
	int tt

Refresh (1)
Pause()

let hwnd = FindWindow (GetAppMainWindow (GetFocus()), "TCS" )
let hwnd = FindWindow( hwnd, "TCS" )
;SayString(GetWindowClass (hwnd))

SaveCursor ()
JAWSCursor ()
Pause ()
MoveToWindow (hwnd)

let text = ""
If gsBeat == "" Then
	; song is playing, so search for the bar and then find the chords between adjacent bars
	let gsChords = ""
	; look for the bar number
	FindString (hwnd, " " + gsBar, S_TOP, S_RESTRICTED, TRUE)
	NextWord ()
	let iBreak = 0
	while iBreak >= 0
		; get the chords between this bar and the next bar
		NextChunk()
		let sTmp = GetChunk ()
		let sTmp = stringStripAllBlanks (sTmp)
		if StringContainsChars (StringLeft (sTmp, 1), "t0123456789") || iBreak>4 then
			; if the first character is a "t" or number, this cannot be a chord, thus we have found all the chords between this bar and the next
			let iBreak = -999
		else
			let text = text + " " + sTmp
		EndIf
		let iBreak = iBreak + 1
	EndWhile
	let gsChords = text

Else
; song is not playing so find the highlighted chord
			let ret = FindColors (IgnoreColor, nChordBackgroundColor, s_NEXT, FALSE )
;		let ret = FindColors (IgnoreColor, nChordBackgroundColor, S_TOP)
;				SayInteger(nChordBackgroundColor)
;		SayInteger(RGBStringToColor ("127127127"))
	if ret == 1 then 
				; a highlighted chord was found
		let text = GetChunk ()
		NextChunk ()
		PriorCharacter ()
		; search for a second highlighted chord
		let ret = FindColors (IgnoreColor, nChordBackgroundColor, s_next, true )
		if ret == 1 then
			; a second highlighted chord was found
			let text = text + " " + GetChunk ()
		EndIf
	EndIf
	; done checking for chords because there can only be a maximum of two chords in any half measure

	RestoreCursor ()
		let gsChords = text
EndIf

EndFunction



Void Function SayChord (string Text)
var
  int i,
  int NChords,
  string ch,
  string str,
  string TextOut,
  int nCarats,
  string PushText,
string ChordBreakText,
  string EndText

if giIsPlaying && giSpeakWhilePlaying >= 3 then return EndIf

; sometimes a sus chord runs into a second chord without a space
Text = StringReplaceSubstrings (Text, "sus", "sus ")

; if there is a space, then we have multiple chords
let NChords = StringSegmentCount (Text, " ")
;SayInteger(nChords)
let i = 1
while ( i <= NChords )
; process each chord separately

; initialize output strings
let TextOut = ""
let EndText = ""
let ChordBreakText = ""
let PushText = ""

; grab the next chord and start processing it
let str =  StringSegment (text, " ", i)  

; if this is a tag, speak it
if StringContains (str, "tag") && !giIsPlaying then
	let TextOut = "tag" + " "
	let str = StringReplaceSubstrings (str, "tag", "")
EndIf

; remove characters that we don't want to speak
let str = StringReplaceChars (str, "[]{}", " ")
let str = stringStripAllBlanks (str)

; if the chord begins with a special character, strip it
let ch = StringLeft(str,1)
let nCarats = 0
while ( ch == "^" )
  let nCarats = nCarats + 1
  let str = StringChopLeft(str,1)
  let ch = StringLeft(str,1)
EndWhile
if nCarats == 1 then
  let PushText = msgPush8
ElIf nCarats == 2 then
  let PushText = msgPush16
EndIf

; if the chord contains a +, it is augmented
if StringContains (str, "+") then
  let str = StringReplaceSubstrings (str, "+", "")
  let EndText = msgAugmented
EndIF

; look for chord breaks
if StringContains ( str, "." ) then
  let ChordBreakText = str
  let str = StringSegment (str, ".", 1)
  let ChordBreakText = ProcessChordBreaks( StringChopLeft( ChordBreakText, StringLength(str) ) )
EndIf

if giIsPlaying && giSpeakWhilePlaying >= 1 then
  ; we are not speaking chord breaks
  let ChordBreakText = ""
EndIf

; determine if this is a suspended chord
if StringContains (str, "sus") then
  let EndText = msgSus
  let str = StringReplaceSubstrings (str, "sus", "" )
EndIf

; determine if this is an augmented chord
if StringContains (str, "aug") then
  let EndText = msgAugmented
  let str = StringReplaceSubstrings (str, "aug", "" )
EndIf

; get the first character - i.e., the chord letter
let ch = StringLeft ( str, 1)
let str = stringChopLeft (str, 1)
let TextOut = TextOut + ch + " "
; the second character tells whether this is a sharpor natural
if StringLength (str) < 1 Then
  ; for a single chord
  let TextOut = TextOut + " " + EndText + " " + ChordBreakText + " " + PushText
;  SayMessage( OT_MESSAGE, TextOut )
Else

let ch = StringLeft (str, 1)
if ch == "b" then
 let TextOut = TextOut + " " + msgFlat
  let str = stringChopLeft (str, 1)
ElIf ch == "#" then
  let TextOut = textOut + " " + msgSharp
  let str = stringChopLeft (str, 1)
EndIf

; check for major or diminished
if StringLength(str) >=3 then
  let ch = stringLeft (str, 3 )
  if ch == "Maj" then
  let TextOut = TextOut + " " + msgMajor
    let str = StringChopLeft( str, 3 )
  ElIf  ch == "dim" then
  let TextOut = TextOut + " " + msgDiminished
    let str = StringChopLeft( str, 3 )
  EndIf
EndIf

; check for minor
if StringLength(str) >= 1 then
  let ch = StringLeft( str, 1 )
  if ch == "m" then
    let TextOut = TextOut + " " + msgMinor
    let str = StringChopLeft( str, 1 )
  EndIf
EndIf

; parse the rest
while ( StringLength(str) >= 1  )
  let ch = StringLeft( str, 1 )
  if ch == "#" then
    let TextOut = TextOut + " " + msgSharp
    let str = StringChopLeft( str, 1 )
  ElIf ch == "b" then
    let TextOut = TextOut + " " + msgFlat
    let str = StringChopLeft( str, 1 )
  ElIf ch == "/" then
    ; for alternate bass note
    let EndText = EndText + " " + msgOver
    let str = StringChopLeft( str, 1 )
    let ch = StringLeft( str, 1 )
    let EndText = EndText + " " + ch
    let str = StringChopLeft( str, 1 )
    ; determine whether this is a sharp or flat
    if StringLength(str) >= 1 then
      let ch = StringLeft( str, 1 )
      if ch == "#" then
        let EndText = EndText + " "  + msgSharp
        let str = StringChopLeft( str, 1 )
      ElIf ch == "b" then
        let EndText = EndText + " "  + " "  + msgFlat
        let str = StringChopLeft( str, 1 )
      EndIf
    EndIf
    let EndText = EndText + " "  + msgBassNote
  Else
  let TextOut = TextOut + ch
  let str = StringChopLeft( str, 1 )
  if StringToInt (ch) > 1 then
    let TextOut = TextOut + " " 
  EndIf
  EndIf
EndWhile

let TextOut = TextOut + " "  + EndText + " "  + ChordBreakText + " "  + PushText + " "

Endif ; end of if statement for single or multiple chords
SayMessage( OT_MESSAGE, TextOut )

NextI:
let i = i+1
EndWhile

EndFunction


String Function ProcessChordBreaks (string Text)
var
  int nPeriods,
  string TextOut,
  string str,
  string ch

; determine the number of "periods"
let nPeriods = StringSegmentCount (Text, ".")
if StringRight (Text, 1) != "." then
  let nPeriods = nPeriods - 1
EndIf

if nPeriods == 1 then
  ; rest
  let TextOut = msgRest
ElIf nPeriods == 2 then
  ; shot
  let TextOut = msgShot
Else
  ; held
  let TextOut = msgHeld
EndIf

; process the rest of the string to find out which instruments are not affected
let str = StringChopLeft( Text, nPeriods )
if StringLength (str) == 0 then
	return TextOut
Else
  let TextOut = Textout + " "  + msgExceptFor
EndIf

while ( StringLength( str ) > 0 )
  let ch = StringLeft( str, 1 )
  if ch == "b" then
    let TextOut = TextOut + " "  + msgBass
  ElIf ch == "d" then
    let TextOut = TextOut + " "  + msgDrums
  ElIf ch == "p" then
    let TextOut = TextOut + " "  + msgPiano
  ElIf ch == "g" then
    let TextOut = TextOut + " "  + msgGuitar
  ElIf ch == "s" then
let textout =     TextOut + " "  + msgStrings
  EndIf
  let str = StringChopLeft( str, 1 )
EndWhile

return TextOut

EndFunction


Script ControlW ()
var
	handle hwnd

let giControlW = 1

TypeCurrentScriptKey ()
delay(5)
let hwnd = FindWindow (GetAppMainWindow(GetFocus()), "", cNotationWindow )
if IsWindowVisible (hwnd) then
	; the notation window is visible
				SayMessage (OT_MESSAGE, msgNotationWindow )
EndIf

let hwnd = FindWindow (GetAppMainWindow(GetFocus()), cChordWindow, "" )

if IsWindowVisible (hwnd) then
	; the Chord window is visible
	SayMessage (OT_MESSAGE, msgChordWindow )
PCCursor ()
EndIf

EndScript

Script SayWindowTitle ()
var
	handle hwnd

if IsSameScript () then
	; speak the song title
	let hwnd = GetAppMainWindow (GetFocus())
	let hwnd = FindWindow (hwnd, cTLMDEdit )
	MoveToWindow (hwnd)
	SayMessage (OT_MESSAGE, msgSongTitle )
	SayWindow (hwnd, READ_EVERYTHING)
	SayMessage (OT_MESSAGE, msgHitEscape )
	RoutePcToJAWS ()
	PCCursor ()
	return
EndIf

PerformScript SayWindowTitle()

EndScript


void function MIDISettingsDialog()
; speaks the instruement and parameters as one moves around the MIDISettings Dialog
var
int i,
int done,
string instrument,
string text,
	handle hwnd,
	handle hwnd0,
	handle hwndtmp

if !IsPCCursor () then return EndIf

; get the handle of the field that has focus
let hwnd0 = GetFocus()

if GetWindowClass (hwnd0) == cTButton then
	return
EndIf

SaveCursor ()
RouteJAWSToPc ()
JawsCursor()
JawsHome()
NextWord ()
; the Thru instrument has to be treated specially since it contains two words
if GetWord () == "Thru" then NextWord () EndIf

let i = 0
let done = 0
while (i<=9) && (done==0) 
	; move through the fields from the beginning until we find the field that currently has the focus
NextWord ()
;MoveToControlType (S_NEXT, WT_EDIT, TRUE)
	let hwnd = GetCurrentWindow ()
	if hwnd != hwndtmp then
		; if we have moved to the next different field, count this as a move
		let i = i + 1
		let hwndtmp = hwnd
	EndIf
	if hwnd == hwnd0 then
		; if we moved to the field that currently has the focus, we're done
		let done = 1
	EndIf
EndWhile

let text = saMSHeadings[i]
if done > 0 then
	SayFormattedMessage( OT_JAWS_MESSAGE, text )
EndIf

RoutePcToJAWS ()
RestoreCursor ()

EndFunction


void function MIDISettingsDialogKeys( string strKeyName )
var
	handle hwnd

if !IsPCCursor () then return EndIf

Refresh (1)

; moves up and down the list of instruments in the MIDI Settings dialog
if strKeyName == "Control+UpArrow" then
	let hwnd = GetNextWindow (GetFocus())
	if hwnd == 0 then
		SayMessage (OT_MESSAGE, msgATEndOfInstrumentsList )
	EndIf
	SetFocus (hwnd)
	Pause ()
	if hwnd != GetFocus() then
		SayMessage (OT_MESSAGE, msgATEndOfInstrumentsList )
	EndIf
ElIf strKeyName == "Control+DownArrow" then
	let hwnd = GetPriorWindow (GetFocus())
	if hwnd == 0 then
		SayMessage (OT_MESSAGE, msgATEndOfInstrumentsList )
	EndIf
	SetFocus (hwnd)
	Pause ()
	if hwnd != GetFocus() then
		SayMessage (OT_MESSAGE, msgATEndOfInstrumentsList )
	EndIf
EndIf

; moves quickly to the other options in this dialog
if strKeyName == "Control+Tab" ||
	strKeyName == "Shift+Control+Tab" then
		if GetWindowTypeCode (GetFocus(), TRUE) == WT_Edit then
		let hwnd = findWindowByType (GetParent(GetFocus()), WT_Button)
		SetFocus (hwnd)
	Else
		let hwnd = findWindowByType (GetParent(GetFocus()), WT_Edit)
		MoveToControlType (S_TOP, WT_EDIT, TRUE)
		SetFocus (hwnd)
	EndIf
EndIf

;MIDISettingsDialog()

EndFunction


string function GetStylePickerMemo ()
	var string description,
		handle hwnd
		hwnd = getFirstChild(getTopLevelWindow (GetFocus()))
While hwnd != 0
		let hwnd = GetNextWindow (hwnd)
		if GetWindowClass (hwnd) == cTMemo then
		let Description = Description + "" + GetWindowText (hwnd, FALSE) + "\n\n"
		EndIf
	EndWhile
return description
endFunction

Script SayMemo ()
var
	handle hwnd,
	handle hwnd0,
	string WindowClass,
	string text,
	string description,
	string sTail,
	int iOut,
int i

if IsSameScript () then
	; output to virtual buffer
	iOut = OT_USER_BUFFER
	let sTail = "\n" + msgHitEscape
Else
	; speech output only
	iOut = OT_MESSAGE
	let sTail = ""
EndIf

let hwnd0 = GetTopLevelWindow (GetFocus())

if giCurrentView == iStylePicker then
		; if the Style Picker is open get the memo field
			text = GetStylePickerMemo() + "\n" + sTail
Elif GetWindowClass(hwnd0) == cTBandWindow then
	; if in the main window
	hwnd = FindWindow (hwnd0, "TBandWindow", "")		
	text = GetWindowName (hwnd0) + sTail
EndIf

PCCursor ()

	SayMessage (iOut, text )

EndScript


void function GoToLyricWindow ()

	MoveToWindow (ghwnd)
	RoutePcToJAWS ()
	PCCursor ()

Endfunction

Script ChordProperties ()
var
	handle hwnd,
	int ret,
	string list,
	string c1,
	string c2,
	int x1,
	int y1,
	int x2,
	int y2

SayChord(gsChords)
if !IsSameScript () then
	; speak the chords phonetically
	SpellModeToggle (FALSE)
	SpellString (gsChords)
	SpellModeToggle (FALSE)
	return
EndIf

let c1 = ""
let c2 = ""

let hwnd = FindWindow (GetAppMainWindow (GetFocus()), cChordWindow )

SaveCursor ()
JAWSCursor ()
MoveToWindow (hwnd)

; find the highlighted chords
; song is not playing so find the highlighted chord
let ret = FindColors (IgnoreColor, nChordBackgroundColor, s_top, true )
if ret == 1 then 
	; a highlighted chord was found
	let c1 = GetChunk ()
	let x1 = GetCursorCol ()
	let y1 = GetCursorRow ()
	NextChunk ()
	PriorCharacter ()
	; search for a second highlighted chord
	let ret = FindColors (IgnoreColor, nChordBackgroundColor, s_next, true )
	if ret == 1 then
		; a second highlighted chord was found
		let c2 = list + "\007 " + GetChunk ()
	let x2 = GetCursorCol ()
	let y2 = GetCursorRow ()
	EndIf
EndIf
; done checking for chords because there can only be a maximum of two chords in any half measure

RestoreCursor ()

; if no highlighted chords wer found then return
if c1 == "" then return EndIf

let ret = DlgSelectItemInList (c1+"\007"+c2, "Select Chord", FALSE, 1, "", -1)

SaveCursor ()
JAWSCursor ()
; move to the selected chord and bring up the context menu
if ret == 1 then
MoveTo (x1, y1 )
Else
	MoveTo (x2, y2 )
EndIf
RestoreCursor ()

; bring up the properties for this chord
RightMouseButton ()

EndScript

Script ToggleSpeakWhilePlaying ()

; change to the next level of speaking
let giSpeakWhilePlaying = giSpeakWhilePlaying + 1
if giSpeakWhilePlaying > 3 then
	let giSpeakWhilePlaying = 0
EndIf

WriteSettingInteger ( "Speech", sSpeakWhilePlaying, giSpeakWhilePlaying, FT_JSI, wdUser, "bbw" )

if giSpeakWhilePlaying == 0 then
	SayMessage (OT_MESSAGE, msgSpeakWhilePlaying0 )
elIf giSpeakWhilePlaying == 1 then
	SayMessage (OT_MESSAGE, msgSpeakWhilePlaying1 )
ElIf giSpeakWhilePlaying == 2 then
	SayMessage (OT_MESSAGE, msgSpeakWhilePlaying2 )
ElIf giSpeakWhilePlaying == 3 then
	SayMessage (OT_MESSAGE, msgSpeakWhilePlaying3 )
EndIf

EndScript

Script HotKeyHelp ()

SayFormattedMessage (OT_USER_BUFFER, msgHotKeyHelp )
;	SayMessage (OT_USER_BUFFER, msgBIABHints )

EndScript


Script SayLastHint ()

If IsSameScript () then
	; 	toggle the setting for automatically speaking hints
	if giSpeakHints == 0 then
		let giSpeakHints = 1
		SayMessage (OT_MESSAGE, msgSpeakHintsOn )
	else
		let giSpeakHints = 0
		SayMessage (OT_MESSAGE, msgSpeakHintsOff )
	EndIf
	return
EndIf

if gsLastHint == "" then
	SayMessage( OT_MESSAGE, msgNoHintAvailable )
else
	SayMessage (OT_MESSAGE, gsLastHint )
EndIf

WriteSettingInteger ( "Speech", sSpeakHints, giSpeakHints, FT_JSI, wdUser, "bbw" )

EndScript
void function MonitorNewTextEventAlerts(handle hFocus, handle hwnd, string buffer, int nAttributes,
	int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)

if nBackGroundColor == nHintColor then
	; grab the last pop-up hint and add to it until a tab or shift+tab is used
	let gsLastHint = gsLastHint + buffer + "\n"
	if giSpeakHints == 1 then
		; speak the hint
		SayMessage (OT_BUFFER, buffer )
	EndIf
EndIf

MonitorNewTextEventAlerts(hFocus, hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)

EndFunction


Script JAWSKeyF1 ()

if IsSameScript ()then
  Run( "\""+FindJAWSSettingsFile ("bbw hotkeys.htm", FALSE )+"\"" )
Else
    Run( "\""+FindJAWSSettingsFile ("bbw.htm", FALSE )+"\"" )
EndIf
	
EndScript



Script NextStyle ()
var string text

MuteSynthesizerToggle (false)
{DownArrow}
Pause()
text = GetStylePickerMemo()
MuteSynthesizerToggle (false)
SayMessage (OT_MESSAGE, text )

EndScript

Script PreviousStyle ()
var string text

MuteSynthesizerToggle (false)
{UpArrow}
Pause()
text = GetStylePickerMemo()
MuteSynthesizerToggle (false)
SayMessage (OT_MESSAGE, text )

EndScript

Script ControlSpace ()
var
	handle hwnd0,
		handle hwnd

hwnd0 = GetCurrentWindow ()
JAWSCursor ()
hwnd = FindWindow (GetTopLevelWindow(GetFocus()), "Tbutton", "Play")
MoveToWindow (hwnd)
LeftMouseButton ()
MoveToWindow (hwnd0)
PCCursor ()

EndScript
Script displayFilterOptions ()
var int index

if giCurrentView != iStylePicker then
	SayMessage(OT_MESSAGE, msgStylePickerNotVisible)
		return
EndIf

index = DlgSelectItemInList ("category\007time signature\007feel\007tempo\007type\007other", msgFilterOptions, false, 1, "", -1)
Pause()
StopSpeech ()
if index > 0 then
  clickStylePickerMenuItem (index-1)
  endIf
;"category\007time signature\007feel\007tempo\007type\007other"
EndScript

Function clickStylePickerMenuItem (int index)
;given the zero-based index of a filtering menu, it moves jaws cursor to that menu and clicks, which opens the menu and causes jaws to automatically enables and routes PC cursor
 if (!moveToStylePickerMenuRow()) then
	sayMessage(OT_MESSAGE, msgUnableToFindFilterOptions )
	return
endIf

var int i
let i = index
while (i > 0)
	nextWord()
	nextWord()
	i = i-1
endWhile

pause()
sayWord()
ClickAtPoint (GetCursorCol (), getCursorRow(), true)

EndFunction

int function moveToStylePickerMenuRow ()
;moves the jaws cursor to the beginning of the line containing the filtering menus
var handle window, int i

window = GettopLevelWindow(GetFocus())
i = FindString (window, "Category", S_TOP, S_UNRESTRICTED, false)

return i

endFunction
;xxx

Script openCategoryMenu ()
clickStylePickerMenuItem (0)
EndScript

Script openTimeSigMenu ()
clickStylePickerMenuItem (1)
EndScript

Script openFeelMenu ()
clickStylePickerMenuItem (2)
EndScript

Script openTempoMenu ()
clickStylePickerMenuItem (3)
EndScript

Script openTypeMenu ()
clickStylePickerMenuItem (4)
EndScript

Script openOtherMenu ()
clickStylePickerMenuItem (5)
EndScript

Script test ()
var
  handle hwnd0,
    handle hwnd
    
    hwnd0 = GetTopLevelWindow (GetFocus())
;hwnd = FindWindow (hwnd0, "TBBMixer", "")
;hwnd = FindWindow (hwnd0, "TMixerControlPanel", "")
hwnd = FindWindow (hwnd0, "TMixerPanel", "")
SayInteger(hwnd)
if hwnd > 0 then
		JAWSCursor ()
	MoveToWindow (hwnd)
		
else
	SayString("not found")
EndIf

EndScript
